import pandas as pd
import numpy as np
from typing import List, Tuple
from sklearn.model_selection import train_test_split

def get_dataset(
    data: pd.DataFrame,
    normalize: bool = False,
    random_state=123
) -> Tuple[np.ndarray, np.ndarray, np.ndarray, np.ndarray, List[str]]:
    """
    Access a dataset.
    Return the train, test split of the data along with the names of the features.
    """
    feature_names = list(data.columns[2:-1])
    label_name = data.columns[-1]
    X = data[feature_names]
    y = data[label_name]

    if normalize:
        eps = 1e-4
        X = (X - X.mean()) / (X.std() + eps)

    X, X_test, y, y_test = train_test_split(
        X, y, random_state=random_state, shuffle=True, test_size=0.2
    )
    X_train, X_val, y_train, y_val = train_test_split(
        X, y, random_state=random_state, shuffle=True, test_size=0.0001
    )
    X_train = np.array(X_train)
    X_val = np.array(X_val)
    X_test = np.array(X_test)
    y_train = np.array(y_train)
    y_val = np.array(y_val)
    y_test = np.array(y_test)
    return X_train, X_val, X_test, y_train, y_val, y_test, feature_names